% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3.R
\name{aws_s3_policy_doc_create}
\alias{aws_s3_policy_doc_create}
\title{Create a policy document for an S3 bucket}
\usage{
aws_s3_policy_doc_create(
  bucket,
  action,
  resource,
  effect = "Allow",
  sid = NULL,
  ...
)
}
\arguments{
\item{bucket}{(character) bucket name. required}

\item{action}{(character) an action. required. see Actions below.}

\item{resource}{(character) the object or objects the statement covers;
see link below for more information}

\item{effect}{(character) valid values: "Allow" (default), "Deny". length==1}

\item{sid}{(character) a statement id. optional}

\item{...}{Additional named arguments. See link in Details for options,
and examples below}
}
\value{
a policy document as JSON (of class \code{json})
}
\description{
Create a policy document for an S3 bucket
}
\details{
There's this separate function for creating policy docs for S3 because
buckets are globally unique, so AWS figures out the region and account
ID for you.
}
\examples{
bucket <- random_bucket()
aws_s3_policy_doc_create(
  bucket = bucket,
  action = s3_actions_read(),
  resource = c(bucket_arn(bucket), bucket_arn(bucket, objects = "*"))
)
}
