% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/users.R
\name{aws_user}
\alias{aws_user}
\title{Get a user}
\usage{
aws_user(username = NULL)
}
\arguments{
\item{username}{(character) A user name. required}
}
\value{
a named list with slots for:
\itemize{
\item user (tibble)
\item policies (list)
\item attached_policies (list)
\item groups (list)
}
}
\description{
Gets user information, including policies, groups, and attached policies
}
\details{
See the following docs links for details
\itemize{
\item \url{https://www.paws-r-sdk.com/docs/iam_get_user/}
\item \url{https://www.paws-r-sdk.com/docs/iam_list_user_policies/}
\item \url{https://www.paws-r-sdk.com/docs/iam_list_groups_for_user/}
\item \url{https://www.paws-r-sdk.com/docs/iam_list_attached_user_policies/}
}
}
\note{
if username not supplied, gets logged in user
}
\examples{
\dontrun{
# if username not supplied, gets the logged in user
aws_user()
}

\dontshow{if (aws_has_creds()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
if (aws_user_exists("testBlueBird")) {
  aws_user_delete("testBlueBird")
}
aws_user_create("testBlueBird")
aws_user("testBlueBird")

# cleanup
aws_user_delete("testBlueBird")
\dontshow{\}) # examplesIf}
}
\seealso{
Other users: 
\code{\link{aws_user_access_key}()},
\code{\link{aws_user_access_key_delete}()},
\code{\link{aws_user_add_to_group}()},
\code{\link{aws_user_create}()},
\code{\link{aws_user_current}()},
\code{\link{aws_user_delete}()},
\code{\link{aws_user_exists}()},
\code{\link{aws_users}()},
\code{\link{six_user_create}()},
\code{\link{six_user_delete}()}
}
\concept{users}
