% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_slope.R
\name{plot_dz}
\alias{plot_dz}
\title{Plot a digital elevation profile based on xyz data}
\usage{
plot_dz(
  d,
  z,
  fill = TRUE,
  horiz = FALSE,
  pal = colorspace::diverging_hcl,
  ...,
  legend_position = "top",
  col = "black",
  cex = 0.9,
  bg = grDevices::rgb(1, 1, 1, 0.8),
  title = "Slope colors (percentage gradient)",
  brks = c(3, 6, 10, 20, 40, 100),
  seq_brks = NULL,
  ncol = 4
)
}
\arguments{
\item{d}{Cumulative distance}

\item{z}{Elevations at points across a linestring}

\item{fill}{Should the profile be filled? \code{TRUE} by default}

\item{horiz}{Should the legend be horizontal (\code{FALSE} by default)}

\item{pal}{Color palette to use, \code{colorspace::diverging_hcl} by default.}

\item{...}{Additional parameters to pass to legend}

\item{legend_position}{The legend position. One of "bottomright", "bottom",
"bottomleft", "left", "topleft", "top" (the default), "topright", "right"
and "center".}

\item{col}{Line colour, black by default}

\item{cex}{Legend size, 0.9 by default}

\item{bg}{Legend background colour, \code{grDevices::rgb(1, 1, 1, 0.8)} by default.}

\item{title}{Title of the legend, "Slope colors (percentage gradient)" by default.}

\item{brks}{Breaks in colour palette to show.
\code{c(3, 6, 10, 20, 40, 100)} by default.}

\item{seq_brks}{Sequence of breaks to show in legend.
By default this is calculated from \code{brks}.}

\item{ncol}{Number of columns in legend, 4 by default.}
}
\value{
A plot is created on the current graphics device.
}
\description{
Plot a digital elevation profile based on xyz data
}
\details{
This function is called by \code{plot_slope()} but can be used directly.
}
\examples{
library(sf)
route_xyz = lisbon_road_segment_3d
m = st_coordinates(route_xyz)
d = cumsum(sequential_dist(m, lonlat = FALSE))
d = c(0, d)
z = m[, 3]
plot_dz(d, z, brks = c(3, 6, 10, 20, 40, 100))
}
