% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_slope.R
\name{plot_slope}
\alias{plot_slope}
\title{Plot slope data for a 3d linestring with base R graphics}
\usage{
plot_slope(
  route_xyz,
  lonlat = sf::st_is_longlat(route_xyz),
  fill = TRUE,
  horiz = FALSE,
  pal = colorspace::diverging_hcl,
  legend_position = "top",
  col = "black",
  cex = 0.9,
  bg = grDevices::rgb(1, 1, 1, 0.8),
  title = "Slope colors (percentage gradient)",
  brks = c(3, 6, 10, 20, 40, 100),
  seq_brks = seq(from = 3, to = length(brks) * 2 - 2),
  ncol = 4,
  ...
)
}
\arguments{
\item{route_xyz}{An sf linestring with x, y and z coordinates,
representing a route or other linear object.}

\item{lonlat}{Are the routes provided in longitude/latitude coordinates?
By default, value is from the CRS of the routes (\code{sf::st_is_longlat(routes)}).}

\item{fill}{Should the profile be filled? \code{TRUE} by default}

\item{horiz}{Should the legend be horizontal (\code{FALSE} by default)}

\item{pal}{Color palette to use, \code{colorspace::diverging_hcl} by default.}

\item{legend_position}{The legend position. One of "bottomright", "bottom",
"bottomleft", "left", "topleft", "top" (the default), "topright", "right"
and "center".}

\item{col}{Line colour, black by default}

\item{cex}{Legend size, 0.9 by default}

\item{bg}{Legend background colour, \code{grDevices::rgb(1, 1, 1, 0.8)} by default.}

\item{title}{Title of the legend, "Slope colors (percentage gradient)" by default.}

\item{brks}{Breaks in colour palette to show.
\code{c(3, 6, 10, 20, 40, 100)} by default.}

\item{seq_brks}{Sequence of breaks to show in legend.
Includes negative numbers and omits zero by default}

\item{ncol}{Number of columns in legend, 4 by default.}

\item{...}{Additional parameters to pass to legend}
}
\value{
A plot object is invisibly returned, and a plot is created on the current graphics device.
}
\description{
Plot slope data for a 3d linestring with base R graphics
}
\examples{
plot_slope(lisbon_route_3d)
route_xyz = lisbon_road_segment_3d
plot_slope(route_xyz)
plot_slope(route_xyz, brks = c(1, 2, 4, 8, 16, 30))
plot_slope(route_xyz, s = 5:8)
}
