% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ss_column_ids.R
\name{ss_column_ids}
\alias{ss_column_ids}
\title{List column ids for a given sheet}
\usage{
ss_column_ids(ss_id)
}
\arguments{
\item{ss_id}{The sheetId, permalink, or name of the Smartsheet sheet to read}
}
\value{
A numeric vector
}
\description{
Returns a vector of the Smartsheet internal column ids for a given sheet
}
\examples{
\dontrun{
ss_id = ss_sheetid(ss_write_sheet(paste0("smartsheetr-example-",random_sheet_name())))
col_names = colnames(ss_read_sheet(ss_id))
col_ids = ss_column_ids(ss_id)
setNames(col_ids, col_names)
# clean up
ss_delete_sheet(ss_id)
}

}
