% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ss_delete_columns.R
\name{ss_delete_columns}
\alias{ss_delete_columns}
\title{Delete non-primary columns from a given sheet.}
\usage{
ss_delete_columns(ss_id, column_ids = NULL)
}
\arguments{
\item{ss_id}{The sheetId, permalink, or name of the Smartsheet sheet to read}

\item{column_ids}{A vector of the smartsheet rowIds, or NULL to delete all non-primary columns}
}
\value{
A list of ss_resp objects
}
\description{
The primary column(s) cannot be deleted.
}
\examples{
\dontrun{
df = data.frame(PK=c(1,2), FK=c("a","b"))
ss_id = ss_sheetid(ss_write_sheet(paste0("smartsheetr-example-",random_sheet_name()), data=df))
col_ids = ss_column_ids(ss_id)
ss_delete_columns(ss_id, col_ids[2])
ss_read_sheet(ss_id)
# clean up
ss_delete_sheet(ss_id)
}

}
