% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smbinning.R
\name{smbinning.logitrank}
\alias{smbinning.logitrank}
\title{Logistic Regression Ranking}
\usage{
smbinning.logitrank(y, chr, df)
}
\arguments{
\item{y}{Binary dependent variable.}

\item{chr}{Vector with the characteristics (independent variables).}

\item{df}{Data frame.}
}
\value{
The command \code{smbinning.logitrank} returns a table with the combination of characteristics 
and their corresponding AIC and deviance. The table is ordered by AIC from lowest (best) to highest.
}
\description{
It runs all the possible logistic models for a given set of characteristics (\code{chr}) and then rank them
from highest to lowest performance based on AIC.
Important Note: This function may take time depending on the datset size and number of variables used in it.
The user should run it at the end of the modeling process once variables have been pre-selected in previous steps.
}
\examples{
# Load library and its dataset
library(smbinning) # Load package and its data

# Example: Best combination of characteristics
smbinning.logitrank(y="fgood",chr=c("chr1","chr2","chr3"),df=smbsimdf3)
}
