% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mm.R
\name{mm}
\alias{mm}
\title{Markov model specification}
\usage{
mm(states, init, ptrans, k = 1)
}
\arguments{
\item{states}{Vector of state space of length s.}

\item{init}{Vector of initial distribution of length s ^ k.}

\item{ptrans}{Matrix of transition probabilities of dimension \eqn{(s, s)}.}

\item{k}{Order of the Markov chain.}
}
\value{
An object of class \link{mm}.
}
\description{
Creates a model specification of a Markov model.
}
\examples{
states <- c("a", "c", "g", "t")
s <- length(states)
k <- 1
init <- rep.int(1 / s, s)
p <- matrix(c(0, 0, 0.3, 0.4, 0, 0, 0.5, 0.2, 0.7, 0.5, 
              0, 0.4, 0.3, 0.5, 0.2, 0), ncol = s)

# Specify a Markov model of order 1
markov <- mm(states = states, init = init, ptrans = p, k = k)

}
\seealso{
\link{simulate.mm}, \link{fitmm}
}
