# Generated by roxytest: do not edit by hand!

# File R/smmnonparametric.R: @testexamples

test_that("Function smmnonparametric() @ L105", {
  
  states <- c("a", "c", "g", "t")
  s <- length(states)
  
  # Creation of the initial distribution
  vect.init <- c(1 / 4, 1 / 4, 1 / 4, 1 / 4)
  
  # Creation of the transition matrix
  pij <- matrix(c(0, 0.2, 0.5, 0.3, 
                  0.2, 0, 0.3, 0.5, 
                  0.3, 0.5, 0, 0.2, 
                  0.4, 0.2, 0.4, 0), 
                ncol = s, byrow = TRUE)
  
  # Creation of a matrix corresponding to the 
  # conditional sojourn time distributions
  kmax <- 6
  nparam.matrix <- matrix(c(0.2, 0.1, 0.3, 0.2, 
                            0.2, 0, 0.4, 0.2, 
                            0.1, 0, 0.2, 0.1, 
                            0.5, 0.3, 0.15, 0.05, 
                            0, 0, 0.3, 0.2, 
                            0.1, 0.2, 0.2, 0), 
                          nrow = s, ncol = kmax, byrow = TRUE)
  
  semimarkov <- smmnonparametric(states = states, init = vect.init, ptrans = pij, 
                                 type.sojourn = "fj", distr = nparam.matrix)
  
  semimarkov
  
  expect_true(all(semimarkov$init - vect.init == 0))
  expect_true(all(semimarkov$ptrans - pij == 0))
  expect_true(is.smm(semimarkov))
  expect_false(is.smmparametric(semimarkov))
  expect_true(is.smmnonparametric(semimarkov))
})

