% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smoothic_functions.R
\name{plot_effects}
\alias{plot_effects}
\title{Plot conditional density curves}
\usage{
plot_effects(
  obj,
  what = "all",
  show_average_indiv = TRUE,
  p = c(0.25, 0.75),
  covariate_fix,
  density_range
)
}
\arguments{
\item{obj}{An object of class \dQuote{\code{smoothic}} which is the result
of a call to \code{\link{smoothic}}.}

\item{what}{The covariate effects to be plotted, default is \code{what = "all"}. The user
may supply a vector of covariate names to be plotted (only covariates selected in the final
model can be plotted).}

\item{show_average_indiv}{Should a \dQuote{baseline} or \dQuote{average} individual be shown,
default is \code{show_average_indiv = TRUE}. If \code{show_average_indiv = FALSE} then this
is not shown.}

\item{p}{The probabilities given to the \code{\link[stats]{quantile}} function. This corresponds to the plotted
red and blue density curves where the chosen covariate is modified as \dQuote{low} and \dQuote{high}.
The default is \code{p = c(0.25, 0.75)} to show the 25th and 75th quantiles.}

\item{covariate_fix}{Optional values to fix the covariates at that are chosen in the final model. When
not supplied, the covariates are fixed at their median values. See the example for more detail.}

\item{density_range}{Optional range for which the density curves should be plotted.}
}
\value{
A plot of the conditional density curves.
}
\description{
This function plots the model-based conditional density curves for
different effect combinations. For example, take a particular covariate that is selected
in the final model. The other selected covariates are fixed at their median values by default
(see \code{covariate_fix} to fix at other values) and then the plotted red and blue densities
correspond to the modification of the chosen covariate as \dQuote{low} (25th quantile by default) and
\dQuote{high} (75th quantile by default).
}
\examples{
# Sniffer Data --------------------
# MPR Model ----
results <- smoothic(
  formula = y ~ .,
  data = sniffer,
  family = "normal",
  model = "mpr"
)
plot_effects(results)

# Only plot gastemp and gaspres
# Do not show the average individual plot
# Plot the lower and upper density curves using 10th quantile (lower) and 90th quantile (upper)
# Fix violent to its violent to 820 and funding to 40

plot_effects(results,
             what = c("gastemp", "gaspres"),
             show_average_indiv = FALSE,
             p = c(0.1, 0.9),
             covariate_fix = c("gastemp" = 70,
                               "gaspres" = 4))

# The curves for the gastemp variable are computed by fixing gaspres = 4 (as is specified
# in the input). The remaining variables that are not specified in covariate_fix are fixed
# to their median values (i.e., tanktemp is fixed at its median). gastemp is then modified
# to be low (10th quantile) and high (90th quantile), as specified by p in the function.

}
\author{
Meadhbh O'Neill
}
