% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/find_smos.R
\name{find_smos}
\alias{find_smos}
\title{Find BEC-SMOS soil moisture data on the server}
\usage{
find_smos(freq, orbit, dates)
}
\arguments{
\item{freq}{an integer specifying temporal frequency of the data. Possible
values are: 1 - for daily data, or 3 - for 3-day moving averages. No
default value is provided.}

\item{orbit}{a character (or character string) specifying SMOS orbit
corresponding to the data. Possible values are: ‘a’, ‘asc’, and ‘ascending’ -
for an ascending pass, or ‘d’, ‘des’, or ‘descending’ - for a descending
pass. No default value is provided.}

\item{dates}{an object of class \code{Date} or a character string formatted
as ‘yyyy-mm-dd’ (e.g. ‘2010-06-01’) which specifies the date(s) to search
through. To look for a specific date, it can be a Date object or a character
vector of length 1. To iterate over various dates or a time interval, a
multiple-element object of class Date or a vector should be passed (e.g. as
produced by \code{seq.Date}).}
}
\value{
a character vector containing full links to the data files on the
server.
}
\description{
This function searches for BEC-SMOS soil moisture data available on Barcelona
Expert Center (BEC) server for the frequency, orbit, and dates specified by
the user.
}
\details{
BEC-SMOS soil moisture (SM) data is a regional root zone SM product that
covers Europe and Mediterranean countries. Particularly, \code{smosr} package
works with the reprocessed SMOS Level 4 (L4) SM estimates downscaled to ~1 km
spatial resolution (EASE-grid v.2). The data is computed for two time periods
(argument \code{frequency}): daily and 3-day moving averages produced by a
temporal aggregation of the daily products. Note that SMOS ascending and
descending passes (argument \code{orbit}) are processed separately. The data
is available starting from June 1st, 2010 throughout the end of 2022. The
currently supported version is 6.0. For more details about the BEC-SMOS SM
products, see the technical note available at
\url{https://digital.csic.es/handle/10261/303808}.

Note that the registration as a user on the Barcelona Expert Center (BEC)
webpage is required to access the server. See
\code{\link[=set_credentials]{set_credentials()}} for details.
}
\examples{
\dontrun{
# to look for BEC-SMOS data on a specific date
smos_data <- find_smos(freq = 1, orbit = "a", dates = "2022-12-31")
# to search data over a date range
start_date <- as.Date("2022-01-01")
end_date <- as.Date("2022-12-31")
date_range <- seq(start_date, end_date, by = 10)
smos_data <- find_smos(freq = 3, orbit = "descending", dates = date_range)
}

}
\references{
Pablos M, Gonzalez-Haro C, Portal G, Piles M, Vall-llossera M,
Portabella M (2022). SMOS L4 Surface Soil Moisture downscaled maps at 1 km
EASE-2 (reprocessed mode) (V.6.0) [Dataset].
}
