% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sm_hgrid.R
\name{sm_hgrid}
\alias{sm_hgrid}
\title{A minimalistic theme of horizontal major grids}
\usage{
sm_hgrid(legends = FALSE, borders = TRUE)
}
\arguments{
\item{legends}{If the legend needs to be displayed, the input should be TRUE.
If the legend is not needed, the input should be FALSE.}

\item{borders}{If the border needs to be displayed, the input should be TRUE.
If the border is not needed, the input should be FALSE.}
}
\value{
Returns a background theme with major horizontal grids (ggplot2 output).
}
\description{
A graph with a horizontal grid is plotted. Border can be added or removed.
This is useful for plotting a bar graph.
}
\examples{
library(ggplot2)
library(smplot2)
ggplot(data = mpg) +
geom_point(mapping = aes(x = displ, y = hwy, color = class)) +
sm_hgrid()
}
