genparam<-
function(
ParamFile=		'galaxy.param',
ParamBase=		'./HernTest/',
InitCondFile=		'./HernStart.gdt',
OutputDir=		'./HernTest/',
EnergyFile=		'energy.txt',
InfoFile=		'info.txt',
TimingsFile=		'timings.txt',
CpuFile=		'cpu.txt',
RestartFile=		'restart',
SnapshotFileBase=	'snapshot',
OutputListFilename=	'parameterfiles/output_list.txt',
TimeLimitCPU=		36000,
ResubmitOn=        	0,
ResubmitCommand=	'my-scriptfile',
ICFormat=              	1,
SnapFormat=            	1,
ComovingIntegrationOn= 	0,
TypeOfTimestepCriterion=0,
OutputListOn=		0,
PeriodicBoundariesOn= 	0,
TimeBegin= 		0.0,
TimeMax=             	0.001,
Omega0=                	0,
OmegaLambda=           	0,
OmegaBaryon=           	0,
HubbleParam=         	1.0,
BoxSize=               	0,
TimeBetSnapshot=        0.00001,
TimeOfFirstSnapshot=    0,
CpuTimeBetRestartFile=  36000.0,
TimeBetStatistics=      0.05,
NumFilesPerSnapshot=    1,
NumFilesWrittenInParallel=1,
ErrTolIntAccuracy=      0.025,
CourantFac=             0.3,
MaxSizeTimestep=        0.1,
MinSizeTimestep=        0.0,
ErrTolTheta=            0.5,
TypeOfOpeningCriterion= 1,
ErrTolForceAcc=         0.005,
TreeDomainUpdateFrequency=    0.1,
DesNumNgb=              32,
MaxNumNgbDeviation=     8,
ArtBulkViscConst=       1.0,
InitGasTemp=            0.e4,
MinGasTemp=             1.e2,
PartAllocFactor=        3.0,
TreeAllocFactor=        4.8,
BufferSize=             25,
UnitLength_in_cm=       3.085678e21,
UnitMass_in_g=          1.989e43,
UnitVelocity_in_cm_per_s=1e5,
GravityConstantInternal= 0,
MinGasHsmlFractional=   0.25,
SofteningGas=           0.0001,
SofteningHalo=          0.0001,
SofteningDisk=          0.4,
SofteningBulge=         0.8,
SofteningStars=         0,
SofteningBndry=         0.1,
SofteningGasMaxPhys=    0.0001,
SofteningHaloMaxPhys=   0.0001,
SofteningDiskMaxPhys=   0.4,
SofteningBulgeMaxPhys=  0.8,
SofteningStarsMaxPhys=  0,
SofteningBndryMaxPhys=  0.1,
MaxRMSDisplacementFac=  0.2,
NFWConcentration=       10,
VirialMass=             200,
FlatRadius=             0.00001,
DeltaVir=               200,
addNFW=			FALSE){

file.create(paste(ParamBase,'/',ParamFile,sep=''))

params=names(formals(genparam))
if(addNFW==FALSE){params=params[1:67]}

for(i in 3:length(params)){
cat(params[i],'\t\t\t',get(params[i]),'\n',file=paste(ParamBase,'/',ParamFile,sep=''),append=TRUE)
}

}
