% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stability.R
\name{stability}
\alias{stability}
\title{Calculates the stability of the food web}
\usage{
stability(
  usin,
  correctstoich = TRUE,
  forceProd = FALSE,
  smin = 1,
  method = "Jacobian"
)
}
\arguments{
\item{usin}{The community to calculate stability.}

\item{correctstoich}{Boolean: Should stability be calculated after the stoichiometry is corrected with corrstoich?}

\item{forceProd}{Boolean: Should production efficiency be the only way to correct stoichiometry?}

\item{smin}{The value of smin in the Moorecobian.}

\item{method}{One of two options: Jacobian or Moorecobian. The later uses the value of smin and adds density-dependence to the calculation at the strength of smin.}
}
\value{
Returns the Jacobian (or Moorecobian), eigenvalues, and the maximum eignvalue as a list.
}
\description{
Calculates the stability of the food web
}
\examples{
# Basic stability calculation
stability(intro_comm)
}
\seealso{
\code{\link{calc_smin}} for the full use of the Moorecobian and \code{\link{stability2}} for the estimation of stability using the functions from \code{\link[rootSolve]{jacobian.full}}
}
