% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/allChannels.R
\name{allChannels}
\alias{allChannels}
\title{Apply a function to all channels of a Wave or WaveMC object}
\usage{
allChannels(
  w,
  FUN,
  cl = NULL,
  channel.param = "channel",
  output.FUN = NULL,
  ...
)
}
\arguments{
\item{w}{A Wave or WaveMC object}

\item{FUN}{Function to apply to the wave.}

\item{cl}{Optionally a cluster for parallel calculation.}

\item{channel.param}{Name of the channel parameter to FUN. Can be NULL.}

\item{output.FUN}{Optional. Function that processes the output of FUN.
The "channels_se" function provides standard functionality for the
soundecology package.}

\item{...}{Optional. Additional parameters to pass to FUN.}
}
\value{
A list of outputs.
}
\description{
Some functions (e.g. ffilter from seewave) only operate on a single
channel at a time. This function applies the function to each channel
and returns a list of analyses.
}
