% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sweptsine.R
\name{sweptsine}
\alias{sweptsine}
\title{Generate a sine sweep}
\usage{
sweptsine(
  f0 = 100,
  f1 = 2500,
  mode = "linear",
  sweep.time = 1,
  time.unit = "seconds",
  samp.rate = 44100,
  output = "wave",
  ...
)
}
\arguments{
\item{f0}{Start frequency}

\item{f1}{End frequency}

\item{mode}{One of "linear", "log"}

\item{sweep.time}{Duration of swept wave}

\item{time.unit}{One of "seconds", "samples"}

\item{samp.rate}{Sample rate of swept wave}

\item{output}{"wave" for a Wave object, or "vector"}

\item{...}{Additional arguments to pass to data2Wave}
}
\value{
A swept wave object of the type specified in output.
}
\description{
Generates a frequency swept sine wave (either linear or logarithmic) and
returns it as a Wave object or vector.
}
\examples{
#Generate a swept sine wave between 0Hz and 10kHz.
w <- sweptsine(0, 10e3)

#Generate a swept sine wave between 0Hz and 10kHz and normalise it.
w <- normalise(sweptsine(0, 10e3))

#Generate a stereo swept sine wave between 100Hz and 1KHz.
w <- tuneR::stereo(sweptsine(100, 1e3))

#Generate an exponentially swept sine wave between 100Hz and 1KHz.
w <- sweptsine(100, 1e3, mode="log")

}
