% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/duckdb-helpers.R
\name{spod_duckdb_limit_resources}
\alias{spod_duckdb_limit_resources}
\title{Set maximum memory and number of threads for a \code{DuckDB} connection}
\usage{
spod_duckdb_limit_resources(
  con,
  max_mem_gb = NULL,
  max_n_cpu = max(1, parallelly::availableCores() - 1)
)
}
\arguments{
\item{con}{A \code{duckdb} connection}

\item{max_mem_gb}{\code{integer} value of the maximum operating memory to use in GB. \code{NULL} by default, delegates the choice to the \code{DuckDB} engine which usually sets it to 80\% of available memory. Caution, in HPC use, the amount of memory available to your job may be determined incorrectly by the \code{DuckDB} engine, so it is recommended to set this parameter explicitly according to your job's memory limits.}

\item{max_n_cpu}{The maximum number of threads to use. Defaults to the number of available cores minus 1.}
}
\value{
A \code{duckdb} connection.
}
\description{
Set maximum memory and number of threads for a \code{DuckDB} connection
}
\keyword{internal}
