% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spareg.R
\name{coef.spar}
\alias{coef.spar}
\title{Coef Method for \code{'spar'} Object}
\usage{
\method{coef}{spar}(
  object,
  nummod = NULL,
  nu = NULL,
  aggregate = c("mean", "median", "none"),
  ...
)
}
\arguments{
\item{object}{result of \link{spar} function of class \code{'spar'}.}

\item{nummod}{number of models used to form coefficients; value with minimal
validation \code{measure} is used if not provided.}

\item{nu}{threshold level used to form coefficients; value with minimal
validation \code{measure} is used if not provided.}

\item{aggregate}{character one of c("mean", "median", "none"). If set to "none"
the coefficients are not aggregated over the marginal models, otherwise
the coefficients are aggregated using the specified method (mean or median).
Defaults to mean aggregation.}

\item{...}{further arguments passed to or from other methods}
}
\value{
object of class  \code{'coefspar'} which is a list with elements
\itemize{
\item \code{intercept} intercept value
\item \code{beta} vector of length p of averaged coefficients
\item \code{nummod} number of models based on which the coefficient is computed
\item \code{nu}  threshold based on which the coefficient is computed
}
}
\description{
Extracts coefficients from \code{'spar'} bbject
}
\examples{
example_data <- simulate_spareg_data(n = 100, p = 400, ntest = 100)
spar_res <- spar(example_data$x, example_data$y, xval = example_data$xtest,
  yval = example_data$ytest, nummods=c(5, 10))
coef(spar_res)
coef(spar_res, aggregate = "median")
coef(spar_res, aggregate = "none")
coef(spar_res, nummod = 5, nu = 0)
}
\seealso{
\link{print.coefspar}, \link{summary.coefspar}
}
