% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Garma_zinb.R
\name{GARMA_ZINB}
\alias{GARMA_ZINB}
\title{Fit Zero-Inflated Negative Binomial GARMA Model with Prediction}
\usage{
GARMA_ZINB(
  cases,
  pop = NULL,
  covariates_count = NULL,
  covariates_zero = NULL,
  p = 2,
  q = 2,
  c = 1,
  beta_init = NULL,
  delta_init = NULL,
  r_init = NULL,
  beta_prior_mean = 0,
  beta_prior_sd = 10,
  delta_prior_mean = 0,
  delta_prior_sd = 10,
  r_prior_shape = 1,
  r_prior_rate = 1,
  n_iter = 1e+05,
  n_burnin = 10000,
  n_chains = 3,
  n_thin = 1,
  save_params = c("r", "beta", "phi", "theta", "delta"),
  covariatespred_count = NULL,
  covariatespred_zero = NULL,
  poppred = NULL,
  casespred = NULL
)
}
\arguments{
\item{cases}{Vector of observed counts (length N)}

\item{pop}{Optional vector of population offsets (length N)}

\item{covariates_count}{Optional numeric matrix (N x P) of covariates for the count component.}

\item{covariates_zero}{Optional numeric matrix (N x Q) of covariates for the zero-inflation component.}

\item{p}{Integer, autoregressive order}

\item{q}{Integer, moving average order}

\item{c}{Constant added before log (default 1)}

\item{beta_init}{Optional list of length n_chains for beta, count coefficients initial values.}

\item{delta_init}{Optional list of length n_chains for delta, zero-inflation coefficients.}

\item{r_init}{Optional numeric vector of length n_chains for dispersion parameter.}

\item{beta_prior_mean}{Mean for beta prior (default: 0)}

\item{beta_prior_sd}{SD   for beta prior (default: 10)}

\item{delta_prior_mean}{Mean for delta prior (default: 0)}

\item{delta_prior_sd}{SD   for delta prior (default: 10)}

\item{r_prior_shape}{Shape for r ~ dgamma (default: 1)}

\item{r_prior_rate}{Rate  for r ~ dgamma (default: 1)}

\item{n_iter}{Total MCMC iterations (default: 100000)}

\item{n_burnin}{Burn-in iterations (default: 10000)}

\item{n_chains}{Number of chains (default: 3)}

\item{n_thin}{Thinning interval (default: 1)}

\item{save_params}{Character vector of parameters to save (default c("beta","delta","r"))}

\item{covariatespred_count}{Optional numeric matrix (M x P) of new covariates for count prediction.}

\item{covariatespred_zero}{Optional numeric matrix (M x Q) of new covariates for zero-inflation prediction.}

\item{poppred}{Optional vector of population offsets (length M) for prediction.}

\item{casespred}{Optional vector of true counts (length M) for prediction performance.}
}
\value{
A list with MCMC summary, samples, DIC, and if prediction data provided:
pred_matrix, pred_mean, mae, rmse
}
\description{
This function fits a generalized autoregressive moving average (GARMA-ZINB)
model for count data using a zero-inflated negative binomial distribution,
allowing separate covariates for the count and zero-inflation parts,
and optionally generates posterior predictive counts for future covariate inputs.
}
\examples{
# ---- tiny example for users & CRAN (< 5s) ----
set.seed(3)
n <- 100
# toy NB counts with extra zeros to mimic zero-inflation
base <- rnbinom(n, size = 5, mu = 6)
zeros <- rbinom(n, size = 1, prob = 0.30)
cases <- ifelse(zeros == 1, 0L, base)

\dontshow{
# checks that run on CRAN but are hidden from users
stopifnot(length(cases) == n, all(cases >= 0))
}

# ---- actually fit the model, but only when JAGS is available ----
\dontshow{if (nzchar(Sys.which("jags")) && requireNamespace("R2jags", quietly = TRUE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
fit <- GARMA_ZINB(
  cases = cases,
  p = 1, q = 1,          # rename if your args are ar_order/ma_order
  # keep priors at defaults unless you need to tweak
  n_iter   = 100,        # keep fast for examples
  n_burnin = 10,
  n_chains = 1,
  n_thin   = 1
)
print(fit)

\donttest{
# ---- longer user-facing demo (skipped on checks) ----
if (nzchar(Sys.which("jags")) && requireNamespace("R2jags", quietly = TRUE)) {
  # simple seasonal covariate (use only if your function supports 'covariates')
  # x <- sin(2*pi*seq_along(cases)/12)
  fit2 <- GARMA_ZINB(
    cases = cases,
    p = 2, q = 1,
    # covariates = cbind(x),        # uncomment if supported
    # z_covariates = cbind(x),      # uncomment if zero-part covariates are supported
    n_iter   = 1000,
    n_burnin = 100,
    n_chains = 2,
    n_thin   = 2
  )
  print(fit2)
  # if a plot method exists:  # plot(fit2)
}
}

\dontrun{
# ---- time-consuming / full demo ----
if (nzchar(Sys.which("jags")) && requireNamespace("R2jags", quietly = TRUE)) {
  fit_full <- GARMA_ZINB(
    cases = cases,
    p = 2, q = 2,
    n_iter   = 100000,
    n_burnin = 10000,
    n_chains = 4,
    n_thin   = 1
  )
  print(fit_full)
}
}

if (interactive()) {
  # e.g., plot(fit)
}
\dontshow{\}) # examplesIf}
}
