% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auto_cor.R
\name{auto_cor}
\alias{auto_cor}
\title{Multicollinearity reduction via Pearson correlation}
\usage{
auto_cor(
  x = NULL,
  preference.order = NULL,
  cor.threshold = 0.5,
  verbose = TRUE
)
}
\arguments{
\item{x}{Data frame with predictors, or a \code{variable_selection} object from \code{\link[=auto_vif]{auto_vif()}}. Default: \code{NULL}.}

\item{preference.order}{Character vector specifying variable preference order. Does not need to include all variables in \code{x}. If \code{NULL}, column order is used. Default: \code{NULL}.}

\item{cor.threshold}{Numeric between 0 and 1 (recommended: 0.5 to 0.9). Maximum allowed absolute Pearson correlation between selected variables. Default: \code{0.50}}

\item{verbose}{Logical. If \code{TRUE}, prints messages about operations and removed variables. Default: \code{TRUE}}
}
\value{
List with class \code{variable_selection} containing:
\itemize{
\item \code{cor}: Correlation matrix of selected variables (only if 2+ variables selected).
\item \code{selected.variables}: Character vector of selected variable names.
\item \code{selected.variables.df}: Data frame containing selected variables.
}
}
\description{
Filters predictors using sequential evaluation of pairwise correlations. Predictors are ranked by user preference (or column order) and evaluated sequentially. Each candidate is added to the selected pool only if its maximum absolute correlation with already-selected predictors does not exceed the threshold.
}
\details{
The algorithm follows these steps:
\enumerate{
\item Rank predictors by \code{preference.order} (or use column order if NULL).
\item Initialize selection pool with first predictor.
\item For each remaining candidate:
\itemize{
\item Compute maximum absolute correlation with selected predictors.
\item If max correlation equal or lower than \code{cor.threshold}, add to selected pool.
\item Otherwise, skip candidate.
}
\item Return selected predictors.
}

\strong{Data cleaning}: Variables in \code{preference.order} not found in \code{colnames(x)} are silently removed. Non-numeric columns are removed with a warning. Rows with NA values are removed via \code{\link[=na.omit]{na.omit()}}. Zero-variance columns trigger a warning but are not removed.

This function can be chained with \code{\link[=auto_vif]{auto_vif()}} through pipes (see examples).
}
\examples{
data(
  plants_df,
  plants_predictors
)

y <- auto_cor(
  x = plants_df[, plants_predictors]
)

y$selected.variables
y$cor
head(y$selected.variables.df)
}
\seealso{
\code{\link[=auto_vif]{auto_vif()}}

Other preprocessing: 
\code{\link{auto_vif}()},
\code{\link{case_weights}()},
\code{\link{default_distance_thresholds}()},
\code{\link{double_center_distance_matrix}()},
\code{\link{is_binary}()},
\code{\link{make_spatial_fold}()},
\code{\link{make_spatial_folds}()},
\code{\link{the_feature_engineer}()},
\code{\link{weights_from_distance_matrix}()}
}
\concept{preprocessing}
