% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_curve.r
\name{plot_curve}
\alias{plot_curve}
\title{Plot ranked specification curve}
\usage{
plot_curve(
  df,
  var = .data$estimate,
  group = NULL,
  desc = FALSE,
  ci = TRUE,
  ribbon = FALSE,
  legend = FALSE,
  null = 0
)
}
\arguments{
\item{df}{a data frame resulting from \code{run_specs()}.}

\item{var}{which variable should be evaluated? Defaults to estimate (the effect sizes computed by \code{\link[=run_specs]{run_specs()}}).}

\item{group}{Should the arrangement of the curve be grouped by a particular choice?
Defaults to NULL, but can be any of the present choices (e.g., x, y, controls...)}

\item{desc}{logical value indicating whether the curve should the arranged in a descending order. Defaults to FALSE.}

\item{ci}{logical value indicating whether confidence intervals should be plotted.}

\item{ribbon}{logical value indicating whether a ribbon instead should be plotted.}

\item{legend}{logical value indicating whether the legend should be plotted Defaults to FALSE.}

\item{null}{Indicate what value represents the null hypothesis (Defaults to zero)}
}
\value{
a \link[ggplot2]{ggplot} object.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}
This function is deprecated because the new version of specr uses a new analytic framework.
In this framework, you can plot a similar figure simply by using the generic \code{plot()} function and
adding the argument \code{type = "curve"}.
This function plots the a ranked specification curve. Confidence intervals can be included. Significant results are highlighted (negative = red, positive = blue, grey = nonsignificant). This functions creates the upper panel in \code{plot_specs()}.
}
\examples{
# load additional library
library(ggplot2) # for further customization of the plots

# Run specification curve analysis
results <- run_specs(df = example_data,
                     y = c("y1", "y2"),
                     x = c("x1", "x2"),
                     model = c("lm"),
                     controls = c("c1", "c2"),
                     subsets = list(group1 = unique(example_data$group1),
                                    group2 = unique(example_data$group2)))

# Plot simple specification curve
plot_curve(results)

# Ribbon instead of CIs and customize further
plot_curve(results, ci = FALSE, ribbon = TRUE) +
  geom_hline(yintercept = 0) +
  geom_hline(yintercept = median(results$estimate),
             linetype = "dashed") +
  theme_linedraw()
}
