% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.r
\name{summary.specr.object}
\alias{summary.specr.object}
\title{Summarizing the Specification Curve Analysis}
\usage{
\method{summary}{specr.object}(
  object,
  type = "default",
  group = NULL,
  var = .data$estimate,
  stats = list(median = median, mad = mad, min = min, max = max, q25 = function(x)
    quantile(x, prob = 0.25), q75 = function(x) quantile(x, prob = 0.75)),
  digits = 2,
  rows = 6,
  ...
)
}
\arguments{
\item{object}{An object of class "specr", usually resulting of a call to \code{specr}.}

\item{type}{Different aspects can be summarized and printed. See details for alternative summaries}

\item{group}{In combination with \code{what = "curve"}, provide a vector of one or more variables (e.g., subsets, controls,...) that denote the available analytic choices to group summary of the estimate.}

\item{var}{In combination with \code{what = "curve"}, unquoted name of parameter to be summarized. Defaults to estimate.}

\item{stats}{Named vector or named list of summary functions (individually defined summary functions can included). If it is not named, placeholders (e.g., "fn1") will be used as column names.}

\item{digits}{The number of digits to use when printing the specification table.}

\item{rows}{The number of rows of the specification tibble that should be printed.}

\item{...}{further arguments passed to or from other methods (currently ignored).}
}
\value{
A printed summary of an object of class \code{specr.object}.
}
\description{
\code{summary} method for class "specr". It provides a printed output including
technical details (e.g., cores used, duration of the fitting process, number
of specifications), a descriptive analysis of the overall specification curve,
a descriptive summary of the resulting sample sizes, and a head of the results.
}
\examples{
# Setup up specifications (returns object of class "specr.setup")
specs <- setup(data = example_data,
   y = c("y1", "y2"),
   x = c("x1", "x2"),
   model = "lm",
   controls = c("c1", "c2"),
   subsets = list(group1 = unique(example_data$group1)))

# Run analysis (returns object of class "specr.object")
results <- specr(specs)

# Default summary of the "specr.object"
summary(results)

# Summarize the specification curve descriptively
summary(results, type = "curve")

# Grouping for certain analytical decisions
summary(results,
       type = "curve",
       group = c("x", "y"))

# Using customized functions
summary(results,
        type = "curve",
       group = c("x", "group1"),
       stats = list(median = median,
                    min = min,
                    max = max))
}
\seealso{
The function used to create the "specr.setup" object: \code{setup}.
}
