% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spect.R
\name{create_training_data}
\alias{create_training_data}
\title{Generates modeling data from a person-period data set.}
\usage{
create_training_data(person_period_data, time_col, event_col, cens)
}
\arguments{
\item{person_period_data}{A discrete-time data set. Generally, this will be output
from the `create_person_period_data` function.}

\item{time_col}{A string specifying the name of the column which contains the survival 
time.}

\item{event_col}{A string specifying the name of the column which contains the event
indicator.}

\item{cens}{Specifies how to apply censored data. Valid values are "same" - considers
censorship to occur in the same interval as the survival time, "prev" - considers
censorship to occur in the prior interval, and "half" - considers censorship to occur
in the same interval as survival time if the individual survived for at least half of
that interval.}
}
\value{
A discrete-time data set suitable for training using any binary classifer.
}
\description{
Generates modeling data from a person-period data set.
}
\seealso{
[create_person_period_data()]
}
\author{
Stephen Abrams, \email{stephen.abrams@louisville.edu}
}
\keyword{utilities}
