% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/speech_check.R
\name{speech_check}
\alias{speech_check}
\title{Check the names of legislators}
\usage{
speech_check(tidy_speech, initial, expand = FALSE)
}
\arguments{
\item{tidy_speech}{data.frame.}

\item{initial}{character vector. Initial of the legislators' names. If no
initial is entered, all will be checked.}

\item{expand}{logical. If \code{TRUE}, the legislature to which the name of the legislator
belongs is shown. By default By default is \code{FALSE}.}
}
\value{
list with a data.frame for each initial of legislators' names.
}
\description{
It allows to check that the names of the legislators are
    correctly written before compiling the documents in \code{speech_build}.
}
\examples{
\donttest{
# url <- "http://bit.ly/35AUVF4"
# out <- speech_build(file = url)
# speech_check(out, initial = c("A", "M"), expand = FALSE)
}
}
