% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dendrogram.R
\name{spiral_dendrogram}
\alias{spiral_dendrogram}
\title{Draw dendrogram}
\usage{
spiral_dendrogram(dend, gp = gpar(), track_index = current_track_index())
}
\arguments{
\item{dend}{A \code{\link[stats:dendrogram]{stats::dendrogram}} object.}

\item{gp}{Graphical parameters of the dendrogram edges, mainly as a global setting.}

\item{track_index}{Index of the track.}
}
\value{
Height of the dendrogram.
}
\description{
Draw dendrogram
}
\details{
Graphical parameters for individual edges can be set via the \code{edgePar} attribute on each node in the dendrogram, see \code{\link[stats:dendrogram]{stats::dendrogram}}
for how to set \code{edgePar}.

The dendrogram edges can also be rendered by \code{\link[dendextend:color_branches]{dendextend::color_branches()}}.
}
\examples{
k = 500
dend = as.dendrogram(hclust(dist(runif(k))))
spiral_initialize(xlim = c(0, k), start = 360, end = 360*3)
spiral_track(height = 0.8, background_gp = gpar(fill = "#EEEEEE", col = NA))
spiral_dendrogram(dend)

\donttest{
require(dendextend)
dend = color_branches(dend, k = 4)
spiral_initialize(xlim = c(0, k), start = 360, end = 360*3)
spiral_track(height = 0.8, background_gp = gpar(fill = "#EEEEEE", col = NA))
spiral_dendrogram(dend)
}
}
