% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graphics.R
\name{spiral_highlight_by_sector}
\alias{spiral_highlight_by_sector}
\title{Highlight a sector}
\usage{
spiral_highlight_by_sector(
  x1,
  x2,
  x3 = NULL,
  x4 = NULL,
  padding = unit(1, "mm"),
  gp = gpar(fill = "red")
)
}
\arguments{
\item{x1}{Start location which determines the start of the sector.}

\item{x2}{End location which determines the end of the sector. Note \code{x2} should be larger than x1 and the angular difference between \code{x1} and \code{x2} should be smaller than a circle.}

\item{x3}{Start location which determines the start of the sector on the upper border.}

\item{x4}{End location which determines the end of the sector on the upper border.}

\item{padding}{It controls the radial extension of the sector. The value should be a \code{\link[grid:unit]{grid::unit()}} object with length one or two.}

\item{gp}{Graphical parameters.}
}
\value{
No value is returned.
}
\description{
Highlight a sector
}
\details{
\code{x1} and \code{x2} determine the position of the highlighted sector. If \code{x3} and \code{x4} are not set, the sector extends until the most outside loop.
If \code{x3} and \code{x4} are set, they determine the outer border of the sector. In this case, if \code{x3} and \code{x4} are set, \code{x3} should be larger than \code{x2}.
}
\examples{
spiral_initialize(xlim = c(0, 360*4), start = 360, end = 360*5)
spiral_track()
spiral_axis()
spiral_highlight_by_sector(36, 72)
spiral_highlight_by_sector(648, 684)
spiral_highlight_by_sector(216, 252, 936, 972, gp = gpar(fill = "blue"))
}
