% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glskrigepred.R
\name{glskrigepred}
\alias{glskrigepred}
\title{Generate spatial predictions using the hybrid method of generalized
 least squares ('gls') and kriging ('krige') ('glskrige')}
\usage{
glskrigepred(
  model = var1 ~ 1,
  longlat,
  trainxy,
  predx,
  y,
  longlatpredx,
  corr.args = NULL,
  weights = NULL,
  transformation = "none",
  delta = 1,
  formula.krige = res1 ~ 1,
  vgm.args = c("Sph"),
  anis = c(0, 1),
  alpha = 0,
  block = 0,
  beta,
  nmaxkrige = 12,
  ...
)
}
\arguments{
\item{model}{a formula defining the response variable and predictive variables.}

\item{longlat}{a dataframe contains longitude and latitude of point samples.}

\item{trainxy}{a dataframe contains longitude (long), latitude (lat),
predictive variables and the response variable of point samples. That is,
the location information must be names as 'long' and 'lat'.}

\item{predx}{a dataframe or matrix contains columns of predictive variables
for the grids to be predicted.}

\item{y}{a vector of the response variable in the formula, that is, the left
part of the formula.}

\item{longlatpredx}{a dataframe contains longitude and latitude of point locations
(i.e., the centers of grids) to be predicted. The location information must be
named as 'long' and 'lat'.}

\item{corr.args}{arguments for 'correlation' in 'gls'. See '?corClasses' in 'nlme'
for details. By default, "NULL" is used. When "NULL" is used,
then 'gls' is actually performing 'lm'.}

\item{weights}{describing the within-group heteroscedasticity structure. Defaults
 to "NULL", corresponding to homoscedastic errors. See '?gls' in 'nlme'
for details.}

\item{transformation}{transform the residuals of 'gls' to normalize the data;
can be "sqrt" for square root, "arcsine" for arcsine, "log" or "none"
for non transformation. By default, "none" is used.}

\item{delta}{numeric; to avoid log(0) in the log transformation. The default is 1.}

\item{formula.krige}{formula defining the response vector and (possible) regressor.
an object (i.e., 'variogram.formula') for 'variogram' or a formula for
'krige'. see 'variogram' and 'krige' in 'gstat' for details.}

\item{vgm.args}{arguments for 'vgm', e.g. variogram model of response
variable and anisotropy parameters. see 'vgm' in 'gstat' for details.
By default, "Sph" is used.}

\item{anis}{anisotropy parameters: see notes 'vgm' in 'gstat' for details.}

\item{alpha}{direction in plane (x,y). see variogram in 'gstat' for details.}

\item{block}{block size. see 'krige' in 'gstat' for details.}

\item{beta}{for simple kriging. see 'krige' in 'gstat' for details.}

\item{nmaxkrige}{for a local predicting: the number of nearest observations that
should be used for a prediction or simulation, where nearest is defined in
terms of the space of the spatial locations. By default, 12 observations
are used.}

\item{...}{other arguments passed on to 'gls' and 'krige'.}
}
\value{
A dataframe of longitude, latitude, and predictions.
}
\description{
This function is for generating spatial predictions using the
 hybrid method of 'gls' and 'krige' (glskrige).
}
\examples{
\donttest{
library(spm)
library(nlme)

data(petrel)
data(petrel.grid)

gravel <- petrel[, c(1, 2, 6:9, 5)]
longlat <- petrel[, c(1, 2)]
range1 <- 0.8
nugget1 <- 0.5
model <- log(gravel + 1) ~  long + lat +  bathy + dist + I(long^2) + I(lat^2) +
I(lat^3) + I(bathy^2) + I(bathy^3) + I(dist^2) + I(dist^3) + I(relief^2) + I(relief^3)
y <- log(gravel[, 7] +1)

glskrigepred1 <- glskrigepred(model = model, longlat = longlat, trainxy = gravel,
predx = petrel.grid, y = y, longlatpredx = petrel.grid[, c(1:2)],
transformation = "none", formula.krige = res1 ~ 1,
vgm.args = "Sph", nmaxkrige = 12, corr.args = corSpher(c(range1, nugget1),
form = ~ lat + long, nugget = TRUE))

names(glskrigepred1)

# Back transform 'glskrigepred$predictions' to generate the final predictions
glskrige.predictions <- exp(glskrigepred1$predictions) - 1
range(glskrige.predictions)
}

}
\references{
Pinheiro, J. C. and D. M. Bates (2000). Mixed-Effects Models
in S and S-PLUS. New York, Springer.

Pebesma, E.J., 2004. Multivariable geostatistics in S: the gstat package.
Computers & Geosciences, 30: 683-691.
}
\author{
Jin Li
}
