% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spoiler.R
\name{use_spoiler}
\alias{use_spoiler}
\alias{spoiler}
\alias{hide_spoilers}
\title{Use Spoiler-alert}
\usage{
use_spoiler()

spoiler(ui_element)

hide_spoilers(max = 10, partial = 4)
}
\arguments{
\item{ui_element}{Element to blur}

\item{max}{Blurring intensity of the element by default}

\item{partial}{Blurring intensity when hovering the element}
}
\description{
Load Spoiler-alert dependencies, mark some elements as spoilers, and define
the blurring intensity for these elements.
}
\examples{
if (interactive()) {
  library(shiny)
  library(spoiler)

  # works better in browser

  ui <- fluidPage(
    # Load dependencies
    use_spoiler(),
    column(
      3,
      p("this text can be seen"),
      spoiler(p("this one can't be seen")) # This text will be blurred
    ),
    hide_spoilers()
  )

  server <- function(input, output, session) {}

  shinyApp(ui, server)
}
}
