% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/index.R
\name{index}
\alias{index}
\title{Compute scaled or absolute population indices from a fitted model object, or from posterior samples.}
\usage{
index(
  object,
  newdata,
  timevar,
  ...,
  byvar = NULL,
  type = "group",
  weights = NULL,
  bweights = NULL,
  baseline = NULL,
  alpha = c(0.8, 0.95),
  nsamp = NULL
)
}
\arguments{
\item{object}{A matrix or an object of class gam or brmsfit. If a matrix, columns should correspond to
(posterior) samples of abundance predictions and rows should match the rows in newdata.}

\item{newdata}{A data frame containing a time variable, any grouping variable, and any variables needed
for predicting from object. The data frame will be supplied to the predict method for gam and brms models.
If object is of class gam, any variables needed for prediction that are not available in
newdata will be treated as constant when computing index.
For objects of class brmsfit, all variables needed for predicting need to be available in newdata.
If object is a matrix, the rows of newdata should correspond to the rows of the matrix.}

\item{timevar}{The name of the time variable in newdata over which an index should be computed.}

\item{...}{Further arguments passed to predict functions.}

\item{byvar}{Name of grouping variable in newdata. The default is NULL in which case a single index is computed.
If not null an index is computed for each unique value of the grouping variable.}

\item{type}{Type of index to compute, one of "group", "global", "delta", "raw". If "group", indices for each group
are computed relative to the within group baseline. If "global", relative indices for each group are
computed relative to the global baseline. If "delta", indices for each group are computed relative to
the previous time point. If "raw", absolute (as opposed to relative) indices are computed.}

\item{weights}{Weights for prediction points.}

\item{bweights}{Weights for the baseline. If the argument is NULL, the baseline weights are set to be equal to the weights for
the prediction points divided by the number of time points in the baseline (this assumes that newdata is balanced).}

\item{baseline}{A set of time points that should be used as baseline for indices of type "group" or "global".
The mean of the index over these time points will be one (see Knape 2023).
If missing, the first time point will be used as the baseline.}

\item{alpha}{A vector of alpha levels for computing confidence intervals.}

\item{nsamp}{Number of simulation samples to draw from gam objects. Defaults to NULL,
in which case 1000 samples will be drawn.}
}
\value{
A data frame containing indices and their uncertainties.
}
\description{
Compute scaled or absolute population indices from a fitted model object, or from posterior samples.
}
\details{
The function computes spatio-temporal indices of relative population size using post-stratification of model based predictions, as detailed in Knape (2025).
This is done by summing (weighted) predicted abundances across the prediction grid defined by newdata for the numerator and denominator of the relative index.
\subsection{Warning}{

Large prediction tasks can require substantial memory. Use less rows in newdata,
and/or fewer simulation samples to reduce memory footprint.
}
}
\examples{
library(mgcv)
data(cuckoo)
\donttest{
# Simple model with abundance varying by year and latitude only.
gam_fit = gam(count ~ s(yr, lat), data = cuckoo, family = quasipoisson)

# Compute index relative to first year at three example latitudes
nd = expand.grid(yr = unique(cuckoo$yr), lat = c(55,60,65))
index(gam_fit, time = "yr", newdata = nd)
}

}
\references{
{Knape, J. (2023). Effects of choice of baseline on the uncertainty of population and biodiversity indices.
Environmental and Ecological Statistics, 30, 1--16. \doi{10.1007/s10651-022-00550-7}}

{Knape, J. (2025). Spatially varying population indices.
Ecological Indicators, 174, 113435. \doi{10.1016/j.ecolind.2025.113435}}
}
