% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prepare_sql.R
\name{prepare_sql}
\alias{prepare_sql}
\title{prepare queries and assemble meta data prior to execution}
\usage{
prepare_sql(
  sql,
  quotesql = "yes",
  values = parent.frame(),
  execmethod = "get",
  geometry = NA,
  default.conn = default_conn()
)
}
\arguments{
\item{sql}{An optionally-named list or character vector containing sql
commands, or a tibble returned by \code{\link[=read_sql]{read_sql()}}}

\item{quotesql}{"yes" or "no" - should interpolated characters be quoted by
default? Anything that isn't "no" is treated as "yes".}

\item{values}{An environment containing variables to interpolate into the
SQL. Pass any object that is not an environment (commonly-used options
include "no", NA, FALSE or NULL) if interpolation is to be skipped, or
another environment containing values to interpolate to avoid using
\code{.GlobalEnv}.}

\item{execmethod}{One of "get", "execute", "sendq", "sends" or "spatial" -
which method should be used to execute the query? "get" means
\code{\link[DBI:dbGetQuery]{DBI::dbGetQuery()}}; "execute" means \code{\link[DBI:dbExecute]{DBI::dbExecute()}}; "sendq" means
\link[DBI:dbSendQuery]{DBI::dbSendQuery}; "sends" means \code{\link[DBI:dbSendStatement]{DBI::dbSendStatement()}}; "spatial" means
\code{\link[sf:st_read]{sf::st_read()}}.}

\item{geometry}{If \code{execmethod} is "spatial", which column contains the
geometry? Ignored if \code{execmethod} is not "spatial".}

\item{default.conn}{Either the name of a sqlhelper connection, or a database
connection returned by \code{\link[DBI:dbConnect]{DBI::dbConnect()}} or \code{\link[pool:pool-package]{pool::pool()}}, or NA. This
connection is only used by \code{\link[glue:glue_sql]{glue::glue_sql()}} to quote SQL interpolations;
\code{\link[=prepare_sql]{prepare_sql()}} does not execute any SQL code.}
}
\value{
A tibble containing 1 row per query with the following fields:

\describe{
\item{qname}{character. A name for this query}
\item{quotesql}{"yes" or "no". Should parameterized character values be
quoted for this query?}
\item{interpolate}{"yes" or "no". Should this query
be parameterized with values from R?}
\item{execmethod}{The method to
execute this query. One of "get" (\code{\link[DBI:dbGetQuery]{DBI::dbGetQuery()}}), "execute"
(\code{\link[DBI:dbExecute]{DBI::dbExecute()}}), "sendq" (\code{\link[DBI:dbSendQuery]{DBI::dbSendQuery()}}), "sends"
(\code{\link[DBI:dbSendStatement]{DBI::dbSendStatement()}}) or "spatial" (\code{\link[sf:st_read]{sf::st_read()}})}
\item{geometry}{character. If \code{execmethod} is "spatial", which is the
geometry column?}
\item{conn_name}{character. The name of the database
connection to use for this query. Must be the name of a configured
sqlhelper connection.}
\item{sql}{The sql query as entered}
\item{filename}{The value of \code{file_name}}
\item{prepared_sql}{The sql query
to be executed, i.e. with interpolations and quoting in place}
}
}
\description{
Except for \code{sql}, parameters are default values to be used when none are
supplied in \code{sql} (i.e. when \code{sql} is a tibble returned by \code{\link[=read_sql]{read_sql()}}).
}
\details{
The \code{default.conn} parameter may be used to supply a connection object that
is not a configured sqlhelper connection which can then be used to
interpolate quoted strings.
}
\examples{
library(sqlhelper)
connect(
    system.file("examples/sqlhelper_db_conf.yml",
                package="sqlhelper"),
    exclusive = TRUE
)

n <- 5
foo <- 'bar'
prepped <- prepare_sql(c("select {`foo`}", "select {n}"))
prepped
prepped$prepared_sql

}
