#' UPDATE statement.
#'
#' This class represents a SQL UPDATE statement. It requires a table name.
#'
#' @examples
#' # Create an UPDATE statement for table 'books':
#' update <- StmtUpdate$new("books")
#'
#' @import R6
#' @include Statement.R
#' @export
StmtUpdate <- R6::R6Class("StmtUpdate",
  inherit = Statement,
  public = list(

    #' @description
    #' Initializer.
    #' @param tabl A table name.
    #' @return Nothing.
    initialize = function(tabl) {
      chk::chk_string(tabl)
      private$table <- tabl
    },

    #' @description
    #' Generates the list of tokens representing this statement.
    #' @return A list of Token objects.
    getTokens = function() {
      return(list(.update, .spc,
                  TokenIdentifier$new(private$table)))
    }
  ),
  private = list(
    table = NULL
  )
)
