% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/change_e.r
\name{change_e}
\alias{change_e}
\title{Methods to alter which parameters are estimated in a SS3 \code{.ctl} file.}
\usage{
change_e(ctl_file_in = "em.ctl", ctl_file_out = "em.ctl",
  dat_list = NULL, for_file_in = "forecasts.ss", par_name = NULL,
  par_int = "NA", par_phase = "NA", forecast_num = 0,
  verbose = FALSE, natM_type = NULL, natM_n_breakpoints = NULL,
  natM_lorenzen = NULL, natM_val = NULL)
}
\arguments{
\item{ctl_file_in}{A string providing the path to the input SS \code{.ctl} file.}

\item{ctl_file_out}{A string providing the path to the output SS control file. If the value is \code{NULL}, the file will not be written to the disk.}

\item{dat_list}{An SS data list object as read in from
\code{\link[r4ss]{SS_readdat}} in the \pkg{r4ss} package. Make sure
you select option \code{section=2}.}

\item{for_file_in}{A string providing the path to the input SS
\code{forecast.ss} file.}

\item{par_name}{*A vector of values, separated by commas.  Each value
corresponds to a parameter that you wish to turn on or off in the
\code{ctl_file_in}. The values will later be turned into character values
and used to search for specific lines for each parameter in the
\code{ctl_file_in}, therefore it is best to use full parameter names as
they are specified in \code{ctl_file_in}.}

\item{par_int}{*A vector of initial values, one for each parameter in
\code{par_name}.  Values can be \code{NA} if you do not wish to change the
initial value for a given parameter.}

\item{par_phase}{*A vector of phase values, one for each parameter in
\code{par_name}.  Values can be \code{NA} if you do not wish to change
the phase for a given parameter.}

\item{forecast_num}{*Number of years to perform forecasts. For those years,
the data will be removed from the \code{dat_list}, enabling SS3 to
generate forecasts rather than use the data to fit the model.}

\item{verbose}{When \code{TRUE} messages will be returned
from the function. Often useful for debugging. The default
is \code{FALSE}.}

\item{natM_type}{Deprecated. Should have value NULL.}

\item{natM_n_breakpoints}{Deprecated. Should have value NULL.}

\item{natM_lorenzen}{Deprecated. Should have value NULL.}

\item{natM_val}{Deprecated. Should have value NULL.}
}
\value{
Altered versions of SS3 \code{.ctl} and \code{forecast.ss} files are written
to the disk and the altered \code{dat_list} is returned invisibly.
}
\description{
Takes SS3 \code{.ctl} and \code{forecast.ss} files, along with
  a list structure which houses the data file as read in by
  \code{\link[r4ss]{SS_readdat}}
  and changes which parameters are estimated, how natural mortality is
  estimated, and if forecasts are performed. The function can be called by
  itself or within \code{\link{run_ss3sim}} to alter an estimation model
  \code{.ctl} file.
  If used with \code{\link{run_ss3sim}} the case file should be named
  \code{E}. A suggested (default) case letter is \code{E} for estimation.
}
\details{
Turning parameters on and off is the main function of
  \code{change_e}.  \code{change_e} was not created with the capability of
  adding parameters to a \code{.ctl} file.  The function can only add
  parameters for age specific natural mortality, and only for models with
  one growth morph.  Furthermore, the function is designed to add complexity
  to the natural mortality type and not remove complexity.  Therefore, the
  function will fail if natural mortality in the \code{ctl_file_in} is not
  specified as \code{"1Param"} and \code{natM_type} is anything other than
  \code{NULL} or \code{"1Param"}.
}
\section{Which arguments to specifiy in case files}{

All function argument descriptions that start with an asterisk (*) will be passed
through the case files to \code{\link{run_ss3sim}}. If one of these arguments
is not specified in a case file, then a value of \code{NULL} will be passed,
which may or may not be an appropriate value. Other arguments will be ignored
if specified.
}

\examples{
\dontrun{

d <- system.file("extdata", "models", "cod-om", package = "ss3sim")
data.old <- r4ss::SS_readdat(
  system.file("extdata", "models", "cod-om", "codOM.dat",
    package = "ss3sim"),
  version = NULL, verbose = FALSE)
change_e(
  ctl_file_in = file.path(d, "codOM.ctl"),
  ctl_file_out = file.path(tempdir(), "change_e.ctl"),
  dat_list = data.old,
  for_file_in = file.path(d, "forecast.ss"),
         natM_type = NULL, natM_n_breakpoints = NULL,
         natM_lorenzen = NULL, natM_val = NULL,
         par_name = c("_steep", "SizeSel_P1_Fishery(1)"),
         par_int = c(0.3, 40), par_phase = c(3, 2),
         forecast_num = 0)
# clean up the temporary files
file.remove(file.path(tempdir(), "change_e.ctl"))
}
}
\seealso{
Other change functions: \code{\link{change_data}},
  \code{\link{change_em_binning}},
  \code{\link{change_f_par}}, \code{\link{change_f}},
  \code{\link{change_o}}, \code{\link{change_retro}},
  \code{\link{change_tv}}
}
\author{
Kelli Johnson
}
\concept{change functions}
