% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expand_scenarios.r
\name{expand_scenarios}
\alias{expand_scenarios}
\title{Create vectors of scenario IDs}
\usage{
expand_scenarios(cases = list(D = 0, E = 0, F = 0, M = 0, R = 0),
  species = c("cod", "fla", "sar"))
}
\arguments{
\item{cases}{A named list of cases. The names in the list are the
case IDs and the values are the case values.}

\item{species}{Vector of 3-letter character IDs designating the
species/stock.}
}
\value{
A character vector of scenario IDs. The case IDs will be
alphabetically sorted.
}
\description{
Create vectors of scenarios from case letters, case numbers,
and species codes. Scenarios are passed to
\code{\link{run_ss3sim}} and \code{\link{get_results_all}}. 
Case letters 'D' and 'F' are mandatory and provide the data 
sampling and fishing history for the operating model.
}
\examples{
expand_scenarios()
expand_scenarios(cases = list(D = 0:3, E = 0, F = 0, M = 0, R = 0),
  species = "cod")
}
\seealso{
\code{\link{run_ss3sim}}, \code{\link{get_results_all}}
}
\author{
Cole Monnahan and Sean C. Anderson
}
