% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ssdGSA_individual.R
\name{ssdGSA_individual}
\alias{ssdGSA_individual}
\title{Single Sample Directional Gene Set Analysis Using Individual Weighted Scores}
\usage{
ssdGSA_individual(Data, Gene_sets, Direction_matrix)
}
\arguments{
\item{Data}{Data matrix of gene expressions with gene ensembl ID as row names and columns corresponding to different samples.}

\item{Gene_sets}{A list of gene sets with gene set names as component names, and each component is a vector of gene entrez ID.}

\item{Direction_matrix}{Matrix containing directionality information for each gene, such as effect size, t statistics,
p value of summary statistics. Each row of the direction matrix is for one gene, and there should be at least two columns
(with the 1st column containing gene entrez ID, and 2nd column containing directionality information).}
}
\value{
Matrix of directional gene set scores with rows corresponding to gene sets and columns corresponding to different
samples will be return.
}
\description{
This function is to calculate single sample directional (disease weighted) gene set scores for a given disease using individual weighted scores.
}
\details{
Single sample directional gene set analysis using individual weighted scores inherits the standard gene set variation
analysis(GSVA) method, but also provides the option to use summary statistics from any analysis (disease vs healthy, lesional side vs nonlesional side, etc..)
input to define the direction of gene sets used for directional gene set score calculation for a given disease. This function is
specific for using individual weighted scores.
}
\examples{

ssdGSA_individual(Data = data_matrix_entrezID,
                  Gene_sets = gene_sets[c(1,2,4)],
                  Direction_matrix = direction_matrix
                  )


}
\seealso{
ssdGSA
}
\keyword{analysis}
\keyword{gene}
\keyword{set}
\keyword{variation}
