% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aims_data.R
\docType{data}
\name{aims_data}
\alias{aims_data}
\title{Species Sensitivity Data provided by AIMS}
\format{
An object of class \code{tbl_df} (inherits from \code{tbl},
\code{data.frame}) with 40 rows and 11 columns.
}
\usage{
aims_data
}
\description{
Species Sensitivity Data provided by the Australian Institute of Marine
Science.
}
\details{
Additional information may be available from the primary source for each
chemical:

\describe{
\item{aluminium_marine}{\insertRef{VanDam2018}{ssddata}}
\item{gallium_marine}{\insertRef{VanDam2018}{ssddata}}
\item{molybdenum_marine}{\insertRef{VanDam2018}{ssddata}}
}

The columns are as follows, noting that all information may not be available
for all chemicals:

\describe{
\item{Chemical}{The chemical name (chr).}
\item{Common}{The species common name (chr).}
\item{Conc}{The chemical concentration in micrograms per Litre (dbl).}
\item{Domain}{Tropical, temperate or other filter (chr).}
\item{Life_stage}{Life stage of the test organism (chr).}
\item{Medium}{The medium - fresh or marine water (chr).}
\item{Phylum}{The Phylum name (chr).}
\item{Source}{The endpoint primary data source (chr).}
\item{Species}{The species names name (chr).}
\item{Test_endpoint}{Endpoint statistic, EC10, NEC etc (chr).}
\item{Toxicity_measure}{Type of toxicity measure used (chr).}
}
}
\examples{

head(aims_data)

}
\keyword{datasets}
