% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim_power_best_norm_rank.R
\name{sim_power_best_norm_rank}
\alias{sim_power_best_norm_rank}
\title{Simulate Power to Select Best Group by Ranks (Normal Outcomes)}
\usage{
sim_power_best_norm_rank(
  noutcomes,
  sd,
  dif,
  weights,
  ngroups,
  npergroup,
  nsim,
  conf.level = 0.95
)
}
\arguments{
\item{noutcomes}{Integer. Number of outcomes to evaluate.}

\item{sd}{Numeric vector. Standard deviations for each outcome.}

\item{dif}{Numeric vector. Difference in means between the best and other groups.}

\item{weights}{Numeric vector. Weights per outcome.}

\item{ngroups}{Integer. Number of groups.}

\item{npergroup}{Integer or vector. Number of subjects per group.}

\item{nsim}{Integer. Number of simulations.}

\item{conf.level}{Numeric. Confidence level for the empirical power estimate}
}
\value{
An S3 object of class \code{empirical_power_result}, which contains
the estimated empirical power and its confidence interval. The object can
be printed, formatted, or further processed using associated S3 methods.
See also \code{\link{empirical_power_result}}.
}
\description{
Estimates the empirical power to identify the most promising group as best,
using weighted ranks across outcomes, assuming normally distributed outcomes.
}
\details{
Each outcome is independent and normally distributed. The most promising group
is assumed to have a mean at least \code{dif} higher than the others. Ranks are
weighted and summed per group across outcomes.

If \code{weights} is specified, it is internally scaled to sum to 1.
The most promising group is always considered to be the first group.
}
\examples{
sim_power_best_norm_rank(
  noutcomes = 3,
  sd = c(1, 0.8, 1.5),
  dif = c(0.2, 0.15, 0.3),
  weights = c(0.5, 0.3, 0.2),
  ngroups = 3,
  npergroup = c(30, 25, 25),
  nsim = 1000
)
}
\seealso{
\code{\link{empirical_power_result}}
}
