% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/force_align.R
\name{force_align}
\alias{force_align}
\title{Perform forced alignment with increased gap open penalty}
\usage{
force_align(
  read,
  reference,
  force_overhang = FALSE,
  match_score = 2L,
  mismatch_penalty = 2L
)
}
\arguments{
\item{read}{A character string of the read.}

\item{reference}{A character string of the reference.}

\item{force_overhang}{Logical. If \code{TRUE}, ensures only one end of the
alignment overhangs. Default is \code{FALSE}.}

\item{match_score}{An integer for scoring matches,
ranging from 0 to 255. Default is 2.}

\item{mismatch_penalty}{An integer for mismatch penalties,
ranging from 0 to 255. Default is 2.}
}
\value{
A list of class \code{ssw} containing the input sequences,
the ssw aligner object, and the alignment results.
}
\description{
Perform forced alignment with increased gap open penalty
}
\examples{
\dontshow{if (is_installed_ssw_py()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Results are truncated
a <- force_align("ACTG", "TTTTCTGCCCCCACG")
a

# Format the results
b <- a |> formatter()
b

# Print the formatted results directly
a |> formatter(print = TRUE)
\dontshow{\}) # examplesIf}
}
