% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/join_stages.R
\name{join_stages}
\alias{join_stages}
\alias{join_stages_unsafe}
\alias{join_all}
\title{Join stages}
\usage{
join_stages(object, var, s1, s2)

join_stages_unsafe(object, var, s1, s2)

join_all(object, var, stages, ignore = NULL)
}
\arguments{
\item{object}{an object of class \code{sevt}.}

\item{var}{variable.}

\item{s1}{first stage.}

\item{s2}{second stage.}

\item{stages}{a vector of stage names for variable \code{var}.}

\item{ignore}{vector of stages which will be ignored and left untouched.}
}
\value{
the staged event tree where \code{s1} and \code{s2} are joined.
}
\description{
Join two stages in a staged event tree object, updating
probabilities and log-likelihood accordingly.
}
\details{
This function joins two stages associated to the
same variable,
updating probabilities and log-likelihood if
the object was fitted.
}
\examples{
model <- full(PhDArticles, lambda = 0)
model <- stages_fbhc(model)
model$stages$Kids
model <- join_stages(model, "Kids", "5", "6")
model$stages$Kids
}
\keyword{internal}
