% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stages_simplebhc.R
\name{stages_simplebhc}
\alias{stages_simplebhc}
\title{Backward hill-climbing for simple staged trees}
\usage{
stages_simplebhc(
  object,
  score = function(x) {
     return(-BIC(x))
 },
  scope = NULL,
  max_iter = Inf,
  ignore = object$name_unobserved
)
}
\arguments{
\item{object}{an object of class \code{\link{sevt}}
with fitted probabilities and data,
as returned by \code{\link{full}} or
\code{\link{sevt_fit}}.}

\item{score}{the score function to be maximized.}

\item{scope}{names of variables that should be considered for
the optimization.}

\item{max_iter}{the maximum number of iterations per variable.}

\item{ignore}{vector of stages which will be ignored and left untouched,
by default the name of the unobserved stages stored in
\code{object$name_unobserved}.}
}
\value{
an object of class \code{sevt}, the simple staged tree resulting
from the search.
}
\description{
Greedy search of simple staged event trees
with iterative joining of positions.
}
\details{
This function is similar to the classical
backward hill-climbing implemented in \code{\link{stages_bhc}}, but
instead of joining stages it consider joining of \emph{positions} via
\code{\link{join_positions}}.
Thus, the search is in the space of simple staged tree models if the
initial stage tree is simple.
See the references for additional details.
}
\examples{
mod <- stages_simplebhc(full(Titanic))
plot(mod)
}
\references{
Leonelli M, Varando G.
Structural Learning of Simple Staged Trees,
\emph{arXiv preprint}
\href{https://arxiv.org/abs/2203.04390}{arXiv:2203.04390v1}
}
\seealso{
\code{\link[=join_positions]{join_positions()}}
\code{\link[=sevt_simplify]{sevt_simplify()}}
}
