% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Tarnopolski.R
\name{Abbe}
\alias{Abbe}
\title{A function to compute Abbe values}
\usage{
Abbe(x)
}
\arguments{
\item{x}{A time series}
}
\value{
Abbe value
}
\description{
Calculates "Abbe" values.
}
\details{
"Abbe" values quantify the degree of smoothness of a time series. 
Decreases to zero for very smooth time series, tends to unity for purely white noise.
Following Tarnopolski et al. Physica A 461 (2016) 662-673.
}
\examples{
x = arima.sim(model=list(ar = 0.3), n = 10^4)
Abbe(x)
}
\references{
Tarnopolski et al. (2016), Physica A 461, 662-673.
}
\author{
Sebastian Sippel
}
