/*
 * Decompiled with CFR 0.152.
 */
package vcf;

import beagleutil.Samples;
import blbutil.SampleFileIt;
import java.io.Closeable;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import vcf.VcfEmission;

public class VcfWindow
implements Closeable {
    private final SampleFileIt<? extends VcfEmission> it;
    private final List<VcfEmission> window;
    private int overlap;
    private int cumMarkerCnt;
    private VcfEmission next;

    public VcfWindow(SampleFileIt<? extends VcfEmission> sampleFileIt) {
        if (!sampleFileIt.hasNext()) {
            throw new IllegalArgumentException("No VCF records after filtering");
        }
        this.it = sampleFileIt;
        this.overlap = 0;
        this.cumMarkerCnt = 0;
        this.window = new ArrayList<VcfEmission>(20000);
        this.next = (VcfEmission)sampleFileIt.next();
    }

    public boolean lastWindowOnChrom() {
        return this.next == null || !this.sameChrom(this.next, this.window.get(0));
    }

    private boolean sameChrom(VcfEmission vcfEmission, VcfEmission vcfEmission2) {
        return vcfEmission.marker().chromIndex() == vcfEmission2.marker().chromIndex();
    }

    public boolean canAdvanceWindow() {
        return this.next != null;
    }

    public VcfEmission[] advanceWindow(int n, int n2) {
        if (!this.canAdvanceWindow()) {
            throw new IllegalStateException("canAdvanceWindow()==false");
        }
        this.checkParameters(n, n2);
        ArrayList<VcfEmission> arrayList = new ArrayList<VcfEmission>(n + 1000);
        arrayList.addAll(this.window.subList(this.window.size() - n, this.window.size()));
        int n3 = this.currentChromIndex(arrayList);
        while (arrayList.size() < n2 && this.next != null && this.next.marker().chromIndex() == n3) {
            arrayList.add(this.next);
            this.next = this.it.hasNext() ? (VcfEmission)this.it.next() : null;
        }
        VcfEmission vcfEmission = (VcfEmission)arrayList.get(arrayList.size() - 1);
        while (this.next != null && this.samePosition(vcfEmission, this.next)) {
            arrayList.add(this.next);
            this.next = this.it.hasNext() ? (VcfEmission)this.it.next() : null;
        }
        this.overlap = n;
        this.window.clear();
        this.window.addAll(arrayList);
        this.cumMarkerCnt += this.window.size() - n;
        return this.window.toArray(new VcfEmission[0]);
    }

    private void checkParameters(int n, int n2) {
        if (n < 0 || n >= n2) {
            String string = "overlap=" + n + "windowSize=" + n2;
            throw new IllegalArgumentException(string);
        }
        if (n > this.window.size()) {
            throw new IllegalArgumentException(String.valueOf(n));
        }
        if (n > 0 && this.lastWindowOnChrom()) {
            throw new IllegalArgumentException(String.valueOf(n));
        }
    }

    private int currentChromIndex(List<VcfEmission> list) {
        if (!list.isEmpty()) {
            return list.get(0).marker().chromIndex();
        }
        if (this.next != null) {
            return this.next.marker().chromIndex();
        }
        return -1;
    }

    private boolean samePosition(VcfEmission vcfEmission, VcfEmission vcfEmission2) {
        return vcfEmission.marker().chromIndex() == vcfEmission2.marker().chromIndex() && vcfEmission.marker().pos() == vcfEmission2.marker().pos();
    }

    public File file() {
        return this.it.file();
    }

    public Samples samples() {
        return this.it.samples();
    }

    public int nSamples() {
        return this.it.samples().nSamples();
    }

    public int size() {
        return this.window.size();
    }

    public int overlap() {
        return this.overlap;
    }

    public int cumMarkerCnt() {
        return this.cumMarkerCnt;
    }

    @Override
    public void close() {
        this.it.close();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(1100);
        stringBuilder.append(this.getClass().toString());
        stringBuilder.append("; next: ");
        stringBuilder.append(this.next);
        return stringBuilder.toString();
    }
}

