% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{STATIS_TABLE4}
\alias{STATIS_TABLE4}
\title{Physicochemical Variables Dataset for STATIS Analysis}
\format{
A data frame with 14 columns and multiple rows (one per sampling site):
\describe{
\item{NIT}{Total nitrogen level.}
\item{FOS}{Phosphorus level.}
\item{CAL}{Calcium level.}
\item{STO}{Sodium level.}
\item{PH}{pH measurement.}
\item{MN}{Manganese concentration.}
\item{ZN}{Zinc concentration.}
\item{SS}{Suspended solids.}
\item{ALC}{Alkalinity.}
\item{CL}{Chlorine level.}
\item{CAU}{Exchangeable calcium or equivalent measurement.}
\item{DBO}{Biological oxygen demand.}
\item{POR}{Porosity or related percentage.}
}
}
\usage{
data(STATIS_TABLE4)
}
\description{
This dataset belongs to a project called “Development and application of effective, low-cost methods for the biological monitoring of Costa Rican rivers”
by the National University, and contains measurements of various physicochemical variables collected across several sampling sites.
It is intended to be used in the
examples and demonstrations of the main functions of the package,
particularly those related to multivariate analysis and STATIS methodology.
}
\examples{
data(STATIS_TABLE4)
head(STATIS_TABLE4)

}
\keyword{datasets}
