% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statpsych1.R
\name{ci.cod}
\alias{ci.cod}
\title{Confidence interval for a coefficient of dispersion}
\usage{
ci.cod(alpha, y)
}
\arguments{
\item{alpha}{alpha level for 1-alpha confidence}

\item{y}{vector of scores}
}
\value{
Returns a 1-row matrix. The columns are:
\itemize{
\item Estimate - estimated coefficient of dispersion
\item SE - recovered standard error
\item LL - lower limit of the confidence interval
\item UL - upper limit of the confidence interval
}
}
\description{
Computes a confidence interval for a population coefficient of
dispersion (COD). The COD is a mean absolute deviation from the median
divided by the median. The coefficient of dispersion assumes ratio-scale
scores and is a robust alternative to the coefficient of variation
(see \link[statpsych]{ci.cv}). An approximate standard error is
recovered from the confidence interval.

For more details, see Section 1.27 of Bonett (2021, Volume 1)
}
\examples{
y <- c(30, 20, 15, 10, 10, 60, 20, 25, 20, 30, 10, 5, 50, 40,
       20, 10, 0, 20, 50)
ci.cod(.05, y)

# Should return:
#  Estimate        SE        LL       UL
# 0.5921053 0.1814708 0.3813259 1.092679


}
\references{
\insertRef{Bonett2006}{statpsych}

\insertRef{Bonett2021}{statpsych}
}
