% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/repeatedm.R
\name{repeatedm}
\alias{repeatedm}
\title{Repeated Measures (ANOVA & Multiple Regression)}
\usage{
repeatedm(k, n, mean = 0, sigma = 1, coefvar = NULL,
          sigmaSup = NULL, conf.level = 0.95,
          random = FALSE, dec = 2)
}
\arguments{
\item{k}{number of variables.}

\item{n}{number of observations.}

\item{mean}{vector of means.}

\item{sigma}{vector of standard deviations/covariance-correlation matrix.}

\item{coefvar}{vector (optional) of coefficients of variation.}

\item{sigmaSup}{vector (optional) of standard deviations if sigma is a correlation matrix.}

\item{conf.level}{confidence level for interval in T-Test.}

\item{random}{a logical indicating whether you want a random covariance/variance matrix.}

\item{dec}{number of decimals for observations.}
}
\value{
A data frame.
}
\description{
Repeated Measures (ANOVA & Multiple Regression)
}
\details{
Number of variables must be greater than 3, in order to ensure an ANOVA of repeated measures or a multiple Linear Regression.

   \code{sigma} can represent a vector or a covariance/correlation matrix. In case \code{sigma} is a vector, independent samples are created. By other hand, if it's a correlation matrix parameter \code{sigmaSup} is required. For covariance matrices, the function does not require any other parameter or special treatment.

   If \code{random = TRUE}, a random covariance matrix is generated by using \cite{genpositiveDefMat()}.
}
\examples{
randm <- clusterGeneration::genPositiveDefMat(8, covMethod = "unifcorrmat")
mcov <- randm$Sigma
Sigma <- cov2cor(mcov)
is.corrmatrix(Sigma)
repeatedm(k = 8, n = 8, mean = c(20,5, 30, 15),sigma = Sigma, sigmaSup = 2,  dec = 2)

repeatedm(k = 5, n = 5, mean = c(8,10,5,14,22.5), random = TRUE)
repeatedm(k = 3, n = 8, mean = c(10,5,22.5), sigma = c(3.3,1.5,5), dec = 2)

}
\seealso{
\code{[clusterGeneration::genpositiveDefMat()]}
}
