% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sample2indp.pow.R
\name{sample2indp.pow}
\alias{sample2indp.pow}
\title{Independent normal data}
\usage{
sample2indp.pow(n1, mean = 0, s1= 1, d.cohen, power,
   alternative = c("two.sided", "less", "greater"), delta = 1,
   conf.level = 0.95, dec = 2)
}
\arguments{
\item{n1}{first sample size.}

\item{mean}{vector of sample means.}

\item{s1}{standard deviation for first sample.}

\item{d.cohen}{Cohen's effect.}

\item{power}{power of the test.}

\item{alternative}{a character string specifying the alternative hypothesis for T-Test. Must be one of ``two.sided`` (default), ``greater`` or ``less``. Can be specified just the initial letter.}

\item{delta}{true value of the difference in means.}

\item{conf.level}{confidence level of the interval.}

\item{dec}{number of decimals for observations.}
}
\value{
A list containing the following components:

\itemize{

 \item \code{Data}: a data frame containing the samples created.


 \item \code{Size}: size of each sample.

 \item \code{T.test}: a t-test of the samples.

}
}
\description{
Generates two normal independent samples with desired power and cohen's effect.
}
\details{
Pooled standard deviation= \code{sp} = sqrt{((n1 - 1) sigma1^2 +(n2 - 1) sigma2^2) / (n1 + n2 - 2)}

    \code{d.cohen} = |mean1 - mean2| / sqrt(sp)
}
\examples{
sample2indp.pow(n1 = 30, mean = c(2,3), s1= 0.5, d.cohen = 0.8, power = 0.85, delta = 1)
sample2indp.pow(n1 = 50, mean = c(15.5,16), s1=2 , d.cohen = 0.3, power = 0.33, delta = 0.5)

}
