% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FrequencyTable.R
\name{SimFrequencyTable}
\alias{SimFrequencyTable}
\title{Generate FrequencyTable using simulated distribution}
\usage{
SimFrequencyTable(min, max, M, SD, skew = 0, kurt = 3, n = 10000, seed = NULL)
}
\arguments{
\item{min}{minimum value of raw score}

\item{max}{maximum value of raw score}

\item{M}{mean of the raw scores distribution}

\item{SD}{standard deviation of the raw scores distribution}

\item{skew}{skewness of the raw scores distribution. Defaults to \code{0} for
normal distribution}

\item{kurt}{kurtosis of the raw scores distribution. Defaults to \code{3} for
normal distribution}

\item{n}{number of observations to simulate. Defaults to \code{10000}, but greater
values could be used to generate better estimates. Final number of observations
in the generated Frequency Table may be less - all values lower than \code{min} and
higher than \code{max} are filtered out.}

\item{seed}{the seed value for random number generation}
}
\value{
FrequencyTable object created with simulated data. Consists of:
\itemize{
\item table: data.frame with number of observations (\code{n}), frequency in sample
(\code{freq}), quantile (\code{quan}) and normalized Z-score (\code{Z}) for each point in
raw score
\item status: list containing the total number of simulated observations (\code{n})
and information about raw scores range completion (\code{range}): complete or incomplete
}
}
\description{
It is always best to use raw scores for computing the \code{FrequencyTable}.
They aren't always available - in that case, this function can be used
to simulate the distribution given its descriptive statistics.

This simulation should be always treated as an estimate.

The distribution is generated using the \strong{Fleishmann} method from
\code{\link[SimMultiCorrData:nonnormvar1]{SimMultiCorrData::nonnormvar1()}} function. The
\code{SimMultiCorrData} package needs to be installed.
}
