% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/normalize.R
\name{normalize_scores_df}
\alias{normalize_scores_df}
\title{Normalize raw scores for multiple variables}
\usage{
normalize_scores_df(data, vars, ..., what, retain = FALSE, .dots = list())
}
\arguments{
\item{data}{\code{data.frame} containing raw scores}

\item{vars}{names of columns to normalize. Length of \code{vars}
need to be the same as number of tables provided to either \code{...} or \code{.dots}}

\item{...}{\code{ScoreTable} or \code{FrequencyTable} objects to be used for normalization}

\item{what}{the values to get. One of either:
\itemize{
\item \code{quan} - the quantile of x in the raw score distribution
\item \code{Z} - normalized Z score for the x raw score
\item name of the scale calculated in \code{ScoreTables} provided to \code{...} or
\code{.dots} argument
}}

\item{retain}{either boolean: \code{TRUE} if all columns in the \code{data} are to be
retained, \code{FALSE} if none; or character vector with names of columns to be retained}

\item{.dots}{\code{ScoreTable} or \code{FrequencyTable} objects provided as a list,
instead of individually in \code{...}.}
}
\value{
\code{data.frame} with normalized scores
}
\description{
Wrapper for \code{\link[=normalize_score]{normalize_score()}} that works on data frame
and multiple variables
}
\examples{
# normalize multiple variables with FrequencyTable
suppressMessages({
  ft_H <- FrequencyTable(HEXACO_60$HEX_H)
  ft_E <- FrequencyTable(HEXACO_60$HEX_E)
  ft_X <- FrequencyTable(HEXACO_60$HEX_X)
})

normalize_scores_df(data = head(HEXACO_60), 
                    vars = c("HEX_H", "HEX_E", "HEX_X"),
                    ft_H,
                    ft_E,
                    ft_X,
                    what = "quan")

# normalize multiple variables with ScoreTable
st_H <- ScoreTable(ft_H, STEN)
st_E <- ScoreTable(ft_E, STEN)
st_X <- ScoreTable(ft_X, STEN)

normalize_scores_df(data = head(HEXACO_60), 
                    vars = c("HEX_H", "HEX_E", "HEX_X"),
                    st_H,
                    st_E,
                    st_X,
                    what = "sten")
}
\seealso{
Other score-normalization functions: 
\code{\link{normalize_scores_grouped}()},
\code{\link{normalize_scores_scoring}()},
\code{\link{normalize_score}()}
}
\concept{score-normalization functions}
