% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/theme_steve.R
\name{theme_steve}
\alias{theme_steve}
\title{Steve's Preferred \pkg{ggplot2} Themes and Assorted Stuff}
\usage{
theme_steve(style = "web", font, ...)
}
\arguments{
\item{style}{various styles/adjustments to make to the base theme. Must be
one of the following: "web" (default), "ms", "fira", "custom", or "generic".
The "custom" style is a fancy way of saying "supply your own fonts". Where
"custom" is used in this argument, something must be supplied to the font
argument in this same function.}

\item{font}{a character vector corresponding with a font that the user ideally
has installed on their operating system.}

\item{...}{optional, called for side effects}
}
\value{
No return value. Function is used for its side effect, which is to
format a plot made in the \pkg{ggplot2} package.
}
\description{
\code{theme_steve()} is my default theme framework for graphs I
make with \pkg{ggplot2}. It starts \code{theme_bw()}, which is available in
\pkg{ggplot2}, but adjusts the margins and axes a bit to my liking. The end
result is, I think, a lovely template for graphs I make in R.
}
\details{
The best use of this function may involve the fonts you have installed
on your system. The user should experiment with various options to see what they
like. The "generic" style will use default \pkg{ggplot2} fonts.
}
\examples{
library(ggplot2)

# Experiment with options, those this depends on fonts you have installed.
example_plot() + theme_steve(style='generic')

}
