% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/onemetric_graph.R
\name{onemetric_graph}
\alias{onemetric_graph}
\title{Graph Performance Metric for Various Investments}
\usage{
onemetric_graph(tickers = NULL, ..., gains = NULL, prices = NULL,
  y.metric = "cagr", add.plot = FALSE, sort.tickers = TRUE,
  plot.list = NULL, points.list = NULL, axis.list = NULL,
  pdf.list = NULL, bmp.list = NULL, jpeg.list = NULL, png.list = NULL,
  tiff.list = NULL)
}
\arguments{
\item{tickers}{Character vector of ticker symbols that Yahoo! Finance 
recognizes, if you want to download data on the fly.}

\item{...}{Arguments to pass along with \code{tickers} to 
\code{\link{load_gains}}.}

\item{gains}{Numeric matrix with 1 column of gains for each investment (can 
be a vector if there is only one).}

\item{prices}{Numeric matrix with 1 column of prices for each investment (can 
be a vector if there is only one).}

\item{y.metric}{Character string specifying y-axis performance metric. 
Choices are: 

\code{"mean"} or \code{"sd"} for mean or standard deviation of gains.

\code{"growth"} or \code{"cagr"} for total or annualized growth.

\code{"mdd"} for maximum drawdown.

\code{"sharpe"} or \code{"sortino"} for Sharpe or Sortino ratio.

\code{"alpha"}, \code{"beta"}, or \code{"r.squared"} for those metrics from a 
fitted linear regression on benchmark fund.

\code{"pearson"} or \code{"spearman"} for Pearson or Spearman correlation 
with benchmark fund.

\code{"auto.pearson"} or \code{"auto.spearman"} for Pearson or Spearman 
autocorrelation, defined as the correlation between subsequent gains.}

\item{add.plot}{Logical value for whether to add plot data to current plot 
frame rather than open a new one.}

\item{sort.tickers}{Logical value for whether to sort investments in 
decreasing order of the performance metric.}

\item{plot.list}{List of arguments to pass to \code{\link[graphics]{plot}}.}

\item{points.list}{List of arguments to pass to 
\code{\link[graphics]{points}}.}

\item{axis.list}{List of arguments to pass to \code{\link[graphics]{axis}}.}

\item{pdf.list}{List of arguments to pass to \code{\link[grDevices]{pdf}}.}

\item{bmp.list}{List of arguments to pass to \code{\link[grDevices]{bmp}}.}

\item{jpeg.list}{List of arguments to pass to \code{\link[grDevices]{jpeg}}.}

\item{png.list}{List of arguments to pass to \code{\link[grDevices]{png}}.}

\item{tiff.list}{List of arguments to pass to \code{\link[grDevices]{tiff}}.}
}
\value{
In addition to the graph, a data frame containing the performance metric for 
each investment.
}
\description{
Useful for visualizing the performance of a group of investments. The first 
investment is used as the benchmark if the requested metric requires one.
}
\examples{
\dontrun{
# Compare annualized growth for VFINX, SSO, and UPRO
fig <- onemetric_graph(tickers = c("VFINX", "SSO", "UPRO"), 
                       plot.list = list(ylim = c(0, 50)))
}

}
\references{
Ryan, J.A. and Ulrich, J.M. (2017) quantmod: Quantitative Financial Modelling 
Framework. R package version 0.4-12, 
\url{https://CRAN.R-project.org/package=quantmod}.
}
