% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/localtest.R
\name{localtest}
\alias{localtest}
\title{Test of local structure for spatio-temporal point processes}
\usage{
localtest(X, Z, method = c("K", "g"), k, alpha = 0.05, verbose = TRUE)
}
\arguments{
\item{X}{Background spatio-temporal point pattern. Usually, the most clustered
between \code{X} and \code{Z}. Must be either a \code{stp} or \code{stlp} object.}

\item{Z}{Other spatio-temporal point pattern. Must also be of the same class as \code{X}.}

\item{method}{Character string indicating which version of LISTA function to use:
either
 \code{"K"} or \code{"g"}.
If \code{"K"}, the local spatio-temporal K-function is used to run the test.
If \code{"g"}, the local spatio-temporal pair correlation function is used.}

\item{k}{Number of permutations}

\item{alpha}{Significance level}

\item{verbose}{If TRUE (default) the progress of the test is printed}
}
\value{
A list of class \code{localtest}, containing
\describe{
\item{\code{p}}{A vector of p-values, one for each of the points in \code{X}}
\item{\code{X}}{The background spatio-temporal point pattern given in input}
\item{\code{Z}}{The alternative spatio-temporal point pattern given in input}
\item{\code{alpha}}{The threshold given in input}
\item{\code{Xsig}}{A \code{stp} object storing the resulting significant points}
\item{\code{Xnosig}}{A \code{stp} object storing the resulting non-significant points}
\item{\code{id}}{The ids of the resulting significant points}
}
}
\description{
This function performs the permutation test of the local structure for
spatio-temporal point pattern data, proposed in Siino et al. (2018), as well as for
spatio-temporal point pattern data occurring on the same linear network,
 following
D'Angelo et al. (2021).
}
\details{
The test detects local differences between  \eqn{\textbf{x}} and \eqn{\textbf{z}}
occurring on the same space-time region.

 The test ends providing a vector \eqn{p} of  \eqn{p}- values, one for each point
 in \eqn{\textbf{x}}.

 If the test is  performed for spatio-temporal point patterns as in
   Siino et al. (2018), that is, on an object of class \code{stp}, the LISTA
   functions \eqn{\hat{L}^{(i)}} employed are the local functions of
   Adelfio et al. (2020), documented in
 \link[stpp]{KLISTAhat} and \link[stpp]{LISTAhat} of the \code{stpp} package (Gabriel et al, 2013).

 If the function is applied to a \code{stlp} object, that is, on two spatio-temporal
 point patterns observed on the same linear network \code{L}, the LISTA function
\eqn{\hat{L}^{(i)}} used are the ones proposed in D'Angelo et al. (2021), documented
in  \link{localSTLKinhom} and \link{localSTLginhom}.

Details on the performance of the test are found in Siino et al. (2018) and
D'Angelo et al. (2021), for Euclidean and network spaces, respectively.
}
\examples{



\donttest{

set.seed(2)
X <- rstpp(lambda = function(x, y, t, a) {exp(a[1] + a[2]*x)},
            par = c(.005, 5))
Z <- rstpp(lambda = 30)

test <- localtest(X, Z, method = "K", k = 3)

}


}
\references{
Adelfio, G., Siino, M., Mateu, J., and Rodríguez-Cortés, F. J. (2020). Some properties of local weighted second-order statistics for spatio-temporal point processes. Stochastic Environmental Research and Risk Assessment, 34(1), 149-168.

D’Angelo, N., Adelfio, G., and Mateu, J. (2021). Assessing local differences between the spatio-temporal second-order structure of two point patterns occurring on the same linear network. Spatial Statistics, 45, 100534.

Gabriel, E., Rowlingson, B. S., and Diggle, P. J. (2013). stpp: An R Package for Plotting, Simulating and Analyzing Spatio-Temporal Point Patterns. Journal of Statistical Software, 53(2), 1–29. https://doi.org/10.18637/jss.v053.i02

Siino, M., Rodríguez‐Cortés, F. J., Mateu, J. ,and Adelfio, G. (2018). Testing for local structure in spatiotemporal point pattern data. Environmetrics, 29(5-6), e2463.
}
\seealso{
\link{print.localtest}, \link{summary.localtest}, \link{plot.localtest}
}
\author{
Nicoletta D'Angelo and Marianna Siino
}
